# Cyber Shop POS System - Installation Guide

## System Requirements

- **PHP**: 7.4 or higher
- **MySQL**: 5.7 or higher
- **Web Server**: Apache or Nginx
- **Extensions**: PDO, PDO_MySQL, mbstring, json

## Installation Steps

### 1. Download and Extract

1. Download the POS system files
2. Extract to your web server directory (e.g., `/var/www/html/cyber-pos/`)
3. Set proper file permissions:
   ```bash
   chmod 755 cyber-pos/
   chmod 644 cyber-pos/*.php
   chmod 755 cyber-pos/assets/
   chmod 755 cyber-pos/receipts/
   chmod 755 cyber-pos/logs/
   ```

### 2. Database Setup

1. **Create Database**:
   ```sql
   CREATE DATABASE cyber_pos CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
   ```

2. **Create Database User**:
   ```sql
   CREATE USER 'cyber_pos_user'@'localhost' IDENTIFIED BY 'your_secure_password';
   GRANT ALL PRIVILEGES ON cyber_pos.* TO 'cyber_pos_user'@'localhost';
   FLUSH PRIVILEGES;
   ```

3. **Import Database Schema**:
   ```bash
   mysql -u cyber_pos_user -p cyber_pos < database/schema.sql
   mysql -u cyber_pos_user -p cyber_pos < database/sample_data.sql
   ```

### 3. Configuration

1. **Copy Configuration File**:
   ```bash
   cp config/config.example.php config/config.php
   ```

2. **Update Database Settings** in `config/config.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'cyber_pos');
   define('DB_USER', 'cyber_pos_user');
   define('DB_PASS', 'your_secure_password');
   ```

3. **Update Application Settings**:
   ```php
   define('APP_URL', 'http://yourdomain.com/cyber-pos');
   ```

### 4. Web Server Configuration

#### Apache (.htaccess included)
The system includes an `.htaccess` file for Apache. Ensure `mod_rewrite` is enabled:
```bash
sudo a2enmod rewrite
sudo systemctl restart apache2
```

#### Nginx
Add this to your Nginx configuration:
```nginx
location /cyber-pos {
    try_files $uri $uri/ /cyber-pos/index.php?$query_string;
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

### 5. Security Setup

1. **Create Logs Directory**:
   ```bash
   mkdir logs
   chmod 755 logs
   ```

2. **Secure File Permissions**:
   ```bash
   chmod 600 config/config.php
   chmod 755 receipts/
   chmod 755 assets/
   ```

3. **SSL Certificate** (Recommended):
   - Install SSL certificate for HTTPS
   - Update `APP_URL` to use `https://`

### 6. Testing

1. **Access the Application**:
   - Navigate to `http://yourdomain.com/cyber-pos/`
   - You should see the login page

2. **Test Login**:
   - Admin: `admin@cybershop.ke` / `admin123`
   - Cashier: `cashier@cybershop.ke` / `cashier123`

3. **Test Core Functions**:
   - Create a test sale
   - Generate a receipt
   - Check reports
   - Manage services

## Post-Installation Configuration

### 1. Shop Settings
1. Login as admin
2. Go to Settings page
3. Update shop information:
   - Shop name and address
   - Contact details
   - M-Pesa till number
   - Tax rate
   - Receipt header/footer

### 2. Services Setup
1. Go to Services page
2. Add your cyber shop services:
   - Printing services
   - Internet browsing
   - Document services
   - Stationery items

### 3. User Management
1. Go to Users page
2. Create accounts for your staff
3. Assign appropriate roles

### 4. Categories (Optional)
Add categories in the database for better organization:
```sql
INSERT INTO categories (name, description) VALUES
('Printing', 'All printing services'),
('Internet', 'Internet and browsing services'),
('Documents', 'Document processing services');
```

## Backup and Maintenance

### Daily Backup
Create a daily backup script:
```bash
#!/bin/bash
DATE=$(date +%Y%m%d)
mysqldump -u cyber_pos_user -p cyber_pos > backups/cyber_pos_$DATE.sql
```

### Log Rotation
Setup log rotation for error logs:
```bash
# Add to /etc/logrotate.d/cyber-pos
/path/to/cyber-pos/logs/*.log {
    daily
    rotate 30
    compress
    missingok
    notifempty
}
```

## Troubleshooting

### Common Issues

1. **Database Connection Error**:
   - Check database credentials in `config/config.php`
   - Verify MySQL service is running
   - Check database user permissions

2. **Permission Denied Errors**:
   - Check file permissions
   - Ensure web server can read/write to necessary directories

3. **Session Issues**:
   - Check PHP session configuration
   - Verify session directory permissions

4. **Receipt Generation Issues**:
   - Check if receipts directory is writable
   - Verify browser popup settings

### Error Logs
Check error logs in:
- `logs/error.log` (application errors)
- Web server error logs
- PHP error logs

## Security Recommendations

1. **Change Default Passwords**:
   - Update default admin/cashier passwords immediately

2. **Regular Updates**:
   - Keep PHP and MySQL updated
   - Monitor for security patches

3. **Backup Strategy**:
   - Implement automated daily backups
   - Test backup restoration regularly

4. **Access Control**:
   - Use strong passwords
   - Limit admin access
   - Monitor user activity

## Support

For technical support:
1. Check the troubleshooting section
2. Review error logs
3. Verify configuration settings
4. Test with sample data

## License

This POS system is provided as-is for cyber shop operations in Kenya.