<?php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendJsonResponse(['success' => false, 'message' => 'Method not allowed'], 405);
}

$action = $_POST['action'] ?? '';

try {
    switch ($action) {
        case 'login':
            $email = sanitizeInput($_POST['email'] ?? '');
            $password = $_POST['password'] ?? '';

            if (empty($email) || empty($password)) {
                sendJsonResponse(['success' => false, 'message' => 'Email and password required'], 400);
            }

            if ($auth->login($email, $password)) {
                $user = $auth->getCurrentUser();
                sendJsonResponse([
                    'success' => true,
                    'message' => 'Login successful',
                    'user' => [
                        'id' => $user['id'],
                        'email' => $user['email'],
                        'full_name' => $user['full_name'],
                        'role' => $user['role']
                    ]
                ]);
            } else {
                sendJsonResponse(['success' => false, 'message' => 'Invalid credentials'], 401);
            }
            break;

        case 'logout':
            $auth->logout();
            sendJsonResponse(['success' => true, 'message' => 'Logged out successfully']);
            break;

        case 'check_session':
            if ($auth->isLoggedIn()) {
                $user = $auth->getCurrentUser();
                sendJsonResponse([
                    'success' => true,
                    'user' => [
                        'id' => $user['id'],
                        'email' => $user['email'],
                        'full_name' => $user['full_name'],
                        'role' => $user['role']
                    ]
                ]);
            } else {
                sendJsonResponse(['success' => false, 'message' => 'Not authenticated'], 401);
            }
            break;

        default:
            sendJsonResponse(['success' => false, 'message' => 'Invalid action'], 400);
    }
} catch (Exception $e) {
    logError("Auth API error: " . $e->getMessage());
    sendJsonResponse(['success' => false, 'message' => 'Internal server error'], 500);
}
?>