<?php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

$auth->requireLogin();

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? $_POST['action'] ?? '';

try {
    if ($method === 'POST' && $action === 'initiate_payment') {
        // M-Pesa STK Push simulation
        $phoneNumber = sanitizeInput($_POST['phone_number'] ?? '');
        $amount = floatval($_POST['amount'] ?? 0);
        $reference = sanitizeInput($_POST['reference'] ?? '');

        if (empty($phoneNumber) || $amount <= 0) {
            sendJsonResponse(['success' => false, 'message' => 'Phone number and amount required'], 400);
        }

        // Validate Kenyan phone number
        if (!preg_match('/^(\+254|0)[17]\d{8}$/', $phoneNumber)) {
            sendJsonResponse(['success' => false, 'message' => 'Invalid Kenyan phone number'], 400);
        }

        // Format phone number
        $formattedPhone = preg_replace('/^0/', '254', $phoneNumber);
        $formattedPhone = preg_replace('/^\+/', '', $formattedPhone);

        // In a real implementation, you would integrate with Safaricom M-Pesa API
        // For demo purposes, we'll simulate the process
        
        $transactionId = 'MPX' . time() . rand(1000, 9999);
        
        // Simulate API response
        $response = [
            'success' => true,
            'message' => 'Payment request sent to customer phone',
            'transaction_id' => $transactionId,
            'phone_number' => $formattedPhone,
            'amount' => $amount,
            'status' => 'pending'
        ];

        sendJsonResponse($response);

    } elseif ($method === 'GET' && $action === 'check_status') {
        $transactionId = sanitizeInput($_GET['transaction_id'] ?? '');
        
        if (empty($transactionId)) {
            sendJsonResponse(['success' => false, 'message' => 'Transaction ID required'], 400);
        }

        // In real implementation, check M-Pesa API for transaction status
        // For demo, simulate successful payment after 5 seconds
        $response = [
            'success' => true,
            'status' => 'completed',
            'mpesa_code' => 'QGH' . rand(10000000, 99999999),
            'message' => 'Payment completed successfully'
        ];

        sendJsonResponse($response);

    } elseif ($method === 'POST' && $action === 'verify_code') {
        $mpesaCode = sanitizeInput($_POST['mpesa_code'] ?? '');
        
        if (empty($mpesaCode)) {
            sendJsonResponse(['success' => false, 'message' => 'M-Pesa code required'], 400);
        }

        // In real implementation, verify the M-Pesa code with Safaricom API
        // For demo, validate format and simulate verification
        if (preg_match('/^[A-Z0-9]{10}$/', $mpesaCode)) {
            sendJsonResponse([
                'success' => true,
                'message' => 'M-Pesa code verified successfully',
                'verified' => true
            ]);
        } else {
            sendJsonResponse([
                'success' => false,
                'message' => 'Invalid M-Pesa code format',
                'verified' => false
            ]);
        }

    } else {
        sendJsonResponse(['success' => false, 'message' => 'Invalid request'], 400);
    }
} catch (Exception $e) {
    logError("M-Pesa API error: " . $e->getMessage());
    sendJsonResponse(['success' => false, 'message' => 'Internal server error'], 500);
}
?>