<?php
require_once 'config/config.php';
require_once 'config/database.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

$auth->requireLogin();

$pageTitle = 'Help & Documentation';

include 'includes/header.php';
?>

<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-900">Help & Documentation</h1>
        <p class="mt-2 text-gray-600">Learn how to use the Cyber Shop POS system</p>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
        <!-- Navigation -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 sticky top-4">
                <h3 class="font-semibold text-gray-900 mb-4">Quick Navigation</h3>
                <nav class="space-y-2">
                    <a href="#getting-started" class="block text-sm text-blue-600 hover:text-blue-800">Getting Started</a>
                    <a href="#pos-system" class="block text-sm text-blue-600 hover:text-blue-800">Using POS</a>
                    <a href="#services" class="block text-sm text-blue-600 hover:text-blue-800">Managing Services</a>
                    <a href="#reports" class="block text-sm text-blue-600 hover:text-blue-800">Reports</a>
                    <a href="#users" class="block text-sm text-blue-600 hover:text-blue-800">User Management</a>
                    <a href="#settings" class="block text-sm text-blue-600 hover:text-blue-800">Settings</a>
                    <a href="#troubleshooting" class="block text-sm text-blue-600 hover:text-blue-800">Troubleshooting</a>
                </nav>
            </div>
        </div>

        <!-- Content -->
        <div class="lg:col-span-3 space-y-8">
            <!-- Getting Started -->
            <section id="getting-started" class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">
                    <i class="fas fa-play-circle text-blue-600 mr-2"></i>
                    Getting Started
                </h2>
                <div class="prose prose-sm max-w-none">
                    <p>Welcome to the Cyber Shop POS system! This guide will help you get started quickly.</p>
                    
                    <h4>Default Login Credentials:</h4>
                    <ul>
                        <li><strong>Admin:</strong> admin@cybershop.ke / admin123</li>
                        <li><strong>Cashier:</strong> cashier@cybershop.ke / cashier123</li>
                    </ul>

                    <h4>First Steps:</h4>
                    <ol>
                        <li>Login with admin credentials</li>
                        <li>Go to Settings and update your shop information</li>
                        <li>Add your services and products</li>
                        <li>Create user accounts for your staff</li>
                        <li>Start making sales!</li>
                    </ol>
                </div>
            </section>

            <!-- POS System -->
            <section id="pos-system" class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">
                    <i class="fas fa-cash-register text-blue-600 mr-2"></i>
                    Using the POS System
                </h2>
                <div class="prose prose-sm max-w-none">
                    <h4>Making a Sale:</h4>
                    <ol>
                        <li>Click on services/products to add them to the cart</li>
                        <li>Adjust quantities using the +/- buttons</li>
                        <li>Enter customer name (optional)</li>
                        <li>Apply discount if needed</li>
                        <li>Select payment method</li>
                        <li>Click "Complete Sale" to process</li>
                        <li>Receipt will automatically open for printing</li>
                    </ol>

                    <h4>Payment Methods:</h4>
                    <ul>
                        <li><strong>Cash:</strong> No additional reference needed</li>
                        <li><strong>M-Pesa:</strong> Enter the M-Pesa transaction code</li>
                        <li><strong>Card:</strong> Enter card reference or approval code</li>
                    </ul>

                    <h4>Keyboard Shortcuts:</h4>
                    <ul>
                        <li><strong>Ctrl+S:</strong> Complete sale (when cart has items)</li>
                        <li><strong>Escape:</strong> Clear cart</li>
                        <li><strong>F1:</strong> Open help</li>
                    </ul>
                </div>
            </section>

            <!-- Services Management -->
            <section id="services" class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">
                    <i class="fas fa-box text-blue-600 mr-2"></i>
                    Managing Services & Products
                </h2>
                <div class="prose prose-sm max-w-none">
                    <h4>Adding Services:</h4>
                    <ol>
                        <li>Go to Services page</li>
                        <li>Click "Add Service"</li>
                        <li>Fill in service details (name, price, category)</li>
                        <li>Set status to Active</li>
                        <li>Save the service</li>
                    </ol>

                    <h4>Common Cyber Shop Services:</h4>
                    <ul>
                        <li>Printing (A4 B&W, A4 Color, A3)</li>
                        <li>Internet browsing (30min, 1hr, 2hr)</li>
                        <li>Photocopying</li>
                        <li>Document scanning</li>
                        <li>Laminating</li>
                        <li>Spiral binding</li>
                        <li>CV typing</li>
                        <li>Flash disks and stationery</li>
                    </ul>

                    <h4>Categories:</h4>
                    <p>Organize services into categories like:</p>
                    <ul>
                        <li>Printing Services</li>
                        <li>Internet Services</li>
                        <li>Document Services</li>
                        <li>Stationery</li>
                        <li>Digital Services</li>
                    </ul>
                </div>
            </section>

            <!-- Reports -->
            <section id="reports" class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">
                    <i class="fas fa-chart-bar text-blue-600 mr-2"></i>
                    Sales Reports
                </h2>
                <div class="prose prose-sm max-w-none">
                    <h4>Available Reports:</h4>
                    <ul>
                        <li><strong>Daily Reports:</strong> Today's sales summary</li>
                        <li><strong>Weekly Reports:</strong> Current week performance</li>
                        <li><strong>Monthly Reports:</strong> Monthly sales analysis</li>
                        <li><strong>Custom Range:</strong> Any date range you specify</li>
                    </ul>

                    <h4>Report Features:</h4>
                    <ul>
                        <li>Total revenue and transaction count</li>
                        <li>Service breakdown by popularity and revenue</li>
                        <li>Cashier performance tracking</li>
                        <li>Export to CSV for further analysis</li>
                    </ul>

                    <h4>Exporting Data:</h4>
                    <ol>
                        <li>Select your desired date range</li>
                        <li>Click "Export CSV" button</li>
                        <li>File will download automatically</li>
                        <li>Open in Excel or Google Sheets</li>
                    </ol>
                </div>
            </section>

            <!-- User Management -->
            <section id="users" class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">
                    <i class="fas fa-users text-blue-600 mr-2"></i>
                    User Management (Admin Only)
                </h2>
                <div class="prose prose-sm max-w-none">
                    <h4>User Roles:</h4>
                    <ul>
                        <li><strong>Admin:</strong> Full system access, can manage everything</li>
                        <li><strong>Cashier:</strong> Can only access POS and view their own transactions</li>
                    </ul>

                    <h4>Adding Staff:</h4>
                    <ol>
                        <li>Go to Users page</li>
                        <li>Click "Add User"</li>
                        <li>Enter staff details and assign role</li>
                        <li>Provide login credentials to staff member</li>
                    </ol>

                    <h4>Security Best Practices:</h4>
                    <ul>
                        <li>Use strong passwords (minimum 6 characters)</li>
                        <li>Change default passwords immediately</li>
                        <li>Regularly review user accounts</li>
                        <li>Remove accounts for former employees</li>
                    </ul>
                </div>
            </section>

            <!-- Settings -->
            <section id="settings" class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">
                    <i class="fas fa-cog text-blue-600 mr-2"></i>
                    System Settings
                </h2>
                <div class="prose prose-sm max-w-none">
                    <h4>Shop Information:</h4>
                    <ul>
                        <li>Update shop name, address, and contact details</li>
                        <li>Add M-Pesa till number for customer payments</li>
                        <li>Set tax rate (default 16% VAT for Kenya)</li>
                    </ul>

                    <h4>Receipt Customization:</h4>
                    <ul>
                        <li>Add custom header message</li>
                        <li>Customize footer text</li>
                        <li>Add shop logo URL</li>
                    </ul>

                    <h4>Important Settings:</h4>
                    <ul>
                        <li><strong>Tax Rate:</strong> Set according to Kenya VAT requirements</li>
                        <li><strong>Receipt Footer:</strong> Add promotional messages or contact info</li>
                        <li><strong>Shop Details:</strong> Ensure all contact information is accurate</li>
                    </ul>
                </div>
            </section>

            <!-- Troubleshooting -->
            <section id="troubleshooting" class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">
                    <i class="fas fa-tools text-blue-600 mr-2"></i>
                    Troubleshooting
                </h2>
                <div class="prose prose-sm max-w-none">
                    <h4>Common Issues:</h4>
                    
                    <div class="bg-gray-50 p-4 rounded-lg mb-4">
                        <h5 class="font-medium text-gray-900">Receipt not printing:</h5>
                        <ul class="mt-2">
                            <li>Check if printer is connected and powered on</li>
                            <li>Ensure browser allows popups for this site</li>
                            <li>Try using Chrome or Firefox browser</li>
                            <li>Check printer paper and ink levels</li>
                        </ul>
                    </div>

                    <div class="bg-gray-50 p-4 rounded-lg mb-4">
                        <h5 class="font-medium text-gray-900">Cannot login:</h5>
                        <ul class="mt-2">
                            <li>Check email and password spelling</li>
                            <li>Ensure account is active</li>
                            <li>Contact admin to reset password</li>
                            <li>Clear browser cache and cookies</li>
                        </ul>
                    </div>

                    <div class="bg-gray-50 p-4 rounded-lg mb-4">
                        <h5 class="font-medium text-gray-900">Sales not saving:</h5>
                        <ul class="mt-2">
                            <li>Check internet connection</li>
                            <li>Ensure all required fields are filled</li>
                            <li>Try refreshing the page</li>
                            <li>Contact system administrator</li>
                        </ul>
                    </div>

                    <h4>Getting Support:</h4>
                    <p>If you continue experiencing issues:</p>
                    <ol>
                        <li>Note the exact error message</li>
                        <li>Record the steps that led to the problem</li>
                        <li>Check if the issue happens consistently</li>
                        <li>Contact your system administrator</li>
                    </ol>
                </div>
            </section>
        </div>
    </div>
</div>

<style>
.prose h4 {
    font-weight: 600;
    color: #374151;
    margin-top: 1.5rem;
    margin-bottom: 0.5rem;
}

.prose h5 {
    font-weight: 500;
    color: #374151;
    margin-bottom: 0.5rem;
}

.prose ul, .prose ol {
    margin-top: 0.5rem;
    margin-bottom: 1rem;
}

.prose li {
    margin-top: 0.25rem;
    margin-bottom: 0.25rem;
}

html {
    scroll-behavior: smooth;
}
</style>

</main>
</body>
</html>