<?php
require_once 'config/config.php';
require_once 'config/database.php';
require_once 'includes/auth.php';
require_once 'includes/functions.php';

$auth->requireLogin();

$pageTitle = 'Dashboard';

// Get dashboard statistics
$todayStats = getTodaysSales($db);
$topServices = getTopServices($db);
$cashierPerformance = getCashierPerformance($db);

include 'includes/header.php';
?>

<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-900">Dashboard</h1>
        <p class="mt-2 text-gray-600">Welcome back! Here's what's happening today.</p>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
            <div class="flex items-center">
                <div class="p-2 bg-green-100 rounded-lg">
                    <i class="fas fa-money-bill-wave text-xl text-green-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Today's Sales</p>
                    <p class="text-2xl font-bold text-gray-900">
                        <?php echo formatCurrency($todayStats['total_revenue']); ?>
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
            <div class="flex items-center">
                <div class="p-2 bg-blue-100 rounded-lg">
                    <i class="fas fa-shopping-cart text-xl text-blue-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Transactions</p>
                    <p class="text-2xl font-bold text-gray-900">
                        <?php echo number_format($todayStats['transaction_count']); ?>
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
            <div class="flex items-center">
                <div class="p-2 bg-purple-100 rounded-lg">
                    <i class="fas fa-chart-line text-xl text-purple-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Avg. Transaction</p>
                    <p class="text-2xl font-bold text-gray-900">
                        <?php 
                        $avg = $todayStats['transaction_count'] > 0 ? 
                               $todayStats['total_revenue'] / $todayStats['transaction_count'] : 0;
                        echo formatCurrency($avg);
                        ?>
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
            <div class="flex items-center">
                <div class="p-2 bg-orange-100 rounded-lg">
                    <i class="fas fa-users text-xl text-orange-600"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Active Cashiers</p>
                    <p class="text-2xl font-bold text-gray-900">
                        <?php echo count($cashierPerformance); ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts and Tables -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Top Services -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100">
            <div class="p-6 border-b border-gray-100">
                <h3 class="text-lg font-semibold text-gray-900">Top Services Today</h3>
            </div>
            <div class="p-6">
                <?php if (!empty($topServices)): ?>
                <div class="space-y-4">
                    <?php foreach ($topServices as $index => $service): ?>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                                <span class="text-sm font-medium text-blue-600"><?php echo $index + 1; ?></span>
                            </div>
                            <div>
                                <p class="font-medium text-gray-900"><?php echo htmlspecialchars($service['service_name']); ?></p>
                                <p class="text-sm text-gray-500"><?php echo $service['total_quantity']; ?> transactions</p>
                            </div>
                        </div>
                        <p class="font-semibold text-gray-900">
                            <?php echo formatCurrency($service['total_revenue']); ?>
                        </p>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php else: ?>
                <p class="text-gray-500 text-center py-8">No sales data available</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Cashier Performance -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100">
            <div class="p-6 border-b border-gray-100">
                <h3 class="text-lg font-semibold text-gray-900">Cashier Performance Today</h3>
            </div>
            <div class="p-6">
                <?php if (!empty($cashierPerformance)): ?>
                <div class="space-y-4">
                    <?php foreach ($cashierPerformance as $index => $cashier): ?>
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center">
                                <span class="text-sm font-medium text-green-600"><?php echo $index + 1; ?></span>
                            </div>
                            <div>
                                <p class="font-medium text-gray-900"><?php echo htmlspecialchars($cashier['cashier_name']); ?></p>
                                <p class="text-sm text-gray-500"><?php echo $cashier['transaction_count']; ?> transactions</p>
                            </div>
                        </div>
                        <p class="font-semibold text-gray-900">
                            <?php echo formatCurrency($cashier['total_sales']); ?>
                        </p>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php else: ?>
                <p class="text-gray-500 text-center py-8">No sales data available</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

</main>
</body>
</html>