<?php
if (!isset($auth) || !$auth->isLoggedIn()) {
    header('Location: login.php');
    exit();
}

$currentUser = $auth->getCurrentUser();
$shopSettings = getShopSettings($db);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?>Cyber Shop POS</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/custom.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="bg-white shadow-lg border-b border-gray-200">
        <div class="max-w-7xl mx-auto px-4">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <div class="flex-shrink-0 flex items-center">
                        <i class="fas fa-desktop text-2xl text-blue-600 mr-2"></i>
                        <span class="text-xl font-bold text-gray-900">CyberPOS</span>
                    </div>
                    <div class="hidden md:ml-6 md:flex md:space-x-8">
                        <a href="index.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-home mr-1"></i> Dashboard
                        </a>
                        <a href="pos.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'pos.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-cash-register mr-1"></i> POS
                        </a>
                        <?php if ($auth->isAdmin()): ?>
                        <a href="services.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'services.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-box mr-1"></i> Services
                        </a>
                        <a href="categories.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-tags mr-1"></i> Categories
                        </a>
                        <a href="inventory.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'inventory.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-warehouse mr-1"></i> Inventory
                        </a>
                        <a href="reports.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-chart-bar mr-1"></i> Reports
                        </a>
                        <a href="users.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-users mr-1"></i> Users
                        </a>
                        <a href="settings.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-cog mr-1"></i> Settings
                        </a>
                        <a href="backup.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'backup.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-database mr-1"></i> Backup
                        </a>
                        <?php endif; ?>
                        <a href="transactions.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'transactions.php' ? 'border-blue-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700'; ?> border-b-2 px-1 pt-1 pb-4 text-sm font-medium">
                            <i class="fas fa-receipt mr-1"></i> Transactions
                        </a>
                    </div>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="help.php" class="text-gray-500 hover:text-gray-700" title="Help">
                        <i class="fas fa-question-circle"></i>
                    </a>
                    <a href="profile.php" class="text-gray-500 hover:text-gray-700" title="Profile">
                        <i class="fas fa-user-circle"></i>
                    </a>
                    <span class="text-sm text-gray-700">
                        <i class="fas fa-user mr-1"></i>
                        <?php echo htmlspecialchars($currentUser['full_name']); ?>
                        <span class="text-xs text-gray-500 ml-1">(<?php echo ucfirst($currentUser['role']); ?>)</span>
                    </span>
                    <a href="logout.php" class="text-gray-500 hover:text-gray-700">
                        <i class="fas fa-sign-out-alt"></i>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Mobile menu (hidden by default) -->
    <div class="md:hidden bg-white border-b border-gray-200">
        <div class="px-2 pt-2 pb-3 space-y-1">
            <a href="index.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-home mr-2"></i> Dashboard
            </a>
            <a href="pos.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'pos.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-cash-register mr-2"></i> POS
            </a>
            <?php if ($auth->isAdmin()): ?>
            <a href="services.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'services.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-box mr-2"></i> Services
            </a>
            <a href="categories.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-tags mr-2"></i> Categories
            </a>
            <a href="inventory.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'inventory.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-warehouse mr-2"></i> Inventory
            </a>
            <a href="reports.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-chart-bar mr-2"></i> Reports
            </a>
            <a href="users.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-users mr-2"></i> Users
            </a>
            <a href="settings.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-cog mr-2"></i> Settings
            </a>
            <a href="backup.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'backup.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-database mr-2"></i> Backup
            </a>
            <a href="mpesa_integration.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'mpesa_integration.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-mobile-alt mr-2"></i> M-Pesa
            </a>
            <?php endif; ?>
            <a href="transactions.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'transactions.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-receipt mr-2"></i> Transactions
            </a>
            <a href="help.php" class="block px-3 py-2 text-base font-medium <?php echo basename($_SERVER['PHP_SELF']) == 'help.php' ? 'text-blue-600 bg-blue-50' : 'text-gray-700 hover:text-gray-900 hover:bg-gray-50'; ?>">
                <i class="fas fa-question-circle mr-2"></i> Help
            </a>
        </div>
    </div>

    <main class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">